# CHANGELOG FOR `1.6.X`

## v1.6.8 (2020-04-21)

#### Details

- [#11018](https://github.com/Sylius/Sylius/issues/11018) Fix: Check PropertyPath value for add error to form ([@Coosos](https://github.com/Coosos))
- [#11191](https://github.com/Sylius/Sylius/issues/11191) Separated order items subtotal calculation logic from twig extension ([@4c0n](https://github.com/4c0n))
- [#11341](https://github.com/Sylius/Sylius/issues/11341) [Maintenance] Upgrade packages dependencies & fix 1.6 build ([@lchrusciel](https://github.com/lchrusciel))
- [#11342](https://github.com/Sylius/Sylius/issues/11342) [Maintenance] Remove memory swap ([@lchrusciel](https://github.com/lchrusciel))
- [#11346](https://github.com/Sylius/Sylius/issues/11346) [ADMIN] fix closed gateway config field in payment method form ([@bigboss86](https://github.com/bigboss86))
- [#11363](https://github.com/Sylius/Sylius/issues/11363) Introduce Probot Autolabeler ([@Zales0123](https://github.com/Zales0123))
- [#11364](https://github.com/Sylius/Sylius/issues/11364) fix #11362 : ignore channel locale listener on profiler routes ([@thi3rry](https://github.com/thi3rry))
- [#11380](https://github.com/Sylius/Sylius/issues/11380) Use !default for SCSS variables to allow overriding them ([@pamil](https://github.com/pamil))

## v1.6.7 (2020-03-31)

#### Details

- [#11168](https://github.com/Sylius/Sylius/issues/11168) [Docs] Remove sensio.sphinx.refinclude ([@Tomanhez](https://github.com/Tomanhez))
- [#11111](https://github.com/Sylius/Sylius/issues/11111) [Docs] Recommend trait usage in Plugin Development Guide ([@Zales0123](https://github.com/Zales0123))
- [#11147](https://github.com/Sylius/Sylius/issues/11147) [Plus Docs] Installation guide improvement and Administrator Roles ([@CoderMaggie](https://github.com/CoderMaggie))
- [#11169](https://github.com/Sylius/Sylius/issues/11169) [missing return] Update basic-usage ([@DurandSacha](https://github.com/DurandSacha))
- [#11146](https://github.com/Sylius/Sylius/issues/11146) [Behat][Admin] Fix step with checking number of orders in the list ([@GSadee](https://github.com/GSadee))
- [#11177](https://github.com/Sylius/Sylius/issues/11177) [Documentation] Sylius Plus docs part 2; including fixes to links ([@CoderMaggie](https://github.com/CoderMaggie))
- [#11181](https://github.com/Sylius/Sylius/issues/11181) Sylius Plus feature scope update ([@dukusz](https://github.com/dukusz))
- [#11179](https://github.com/Sylius/Sylius/issues/11179) [Maintenance] Remove uneeded step ([@lchrusciel](https://github.com/lchrusciel))
- [#11192](https://github.com/Sylius/Sylius/issues/11192) Fixtures: fix French translation of cap ([@dunglas](https://github.com/dunglas))
- [#11299](https://github.com/Sylius/Sylius/issues/11299) Remove useless interface in custom_fixture.rst ([@dunglas](https://github.com/dunglas))
- [#11304](https://github.com/Sylius/Sylius/issues/11304) [Docs] Require tagged plugins for Sylius Store ([@Zales0123](https://github.com/Zales0123))
- [#11310](https://github.com/Sylius/Sylius/issues/11310) Install symfony/polyfill-php80 to fix the psalm build ([@Zales0123](https://github.com/Zales0123))

## v1.6.6 (2020-02-28)

#### Details

- [#11065](https://github.com/Sylius/Sylius/issues/11065) user provider fix exception ([@oallain](https://github.com/oallain))
- [#11079](https://github.com/Sylius/Sylius/issues/11079) [Docs] Add organization section to The Book + set up Sphinx redirections ([@pamil](https://github.com/pamil))
- [#11095](https://github.com/Sylius/Sylius/issues/11095) [Promotion] Generating long coupons ([@oallain](https://github.com/oallain), [@GSadee](https://github.com/GSadee))
- [#11097](https://github.com/Sylius/Sylius/issues/11097) [Composer] Add conflicts to fix build for Symfony 3.4 ([@GSadee](https://github.com/GSadee))
- [#11113](https://github.com/Sylius/Sylius/issues/11113) [Docs][Plus] Splitting shipments ([@CoderMaggie](https://github.com/CoderMaggie))
- [#11114](https://github.com/Sylius/Sylius/issues/11114) Fixed wrongly calculated order-item subtotal ([@peterukena](https://github.com/peterukena))
- [#11119](https://github.com/Sylius/Sylius/issues/11119) [Docs] Sphinx instalation guide  ([@Tomanhez](https://github.com/Tomanhez))
- [#11130](https://github.com/Sylius/Sylius/issues/11130) Add documentation to deploy Sylius to SymfonyCloud ([@tucksaun](https://github.com/tucksaun))
- [#11137](https://github.com/Sylius/Sylius/issues/11137) [Docs] Improve installation steps ([@lchrusciel](https://github.com/lchrusciel))
- [#11142](https://github.com/Sylius/Sylius/issues/11142) [Docs] Mention Minimum stability in plus installation ([@Zales0123](https://github.com/Zales0123))

## v1.6.5 (2020-01-27)

#### CVE-2020-5218: Ability to switch channels via GET parameter enabled in production environments

*Please refer to [the original security advisory](https://github.com/Sylius/Sylius/security/advisories/GHSA-prg5-hg25-8grq) for the most updated information.*  

**Impact:**

This vulnerability gives the ability to switch channels via the `_channel_code` GET parameter in production environments. This was meant to be enabled only when `%kernel.debug%` is set to true. 

However, if no `sylius_channel.debug` is set explicitly in the configuration, the default value which is `%kernel.debug%` will be not resolved and cast to boolean, enabling this debug feature even if that parameter is set to false.

**Patches:**

Patch has been provided for Sylius 1.3.x and newer - **1.3.16, 1.4.12, 1.5.9, 1.6.5**. Versions older than 1.3 are not covered by our security support anymore.

**Workarounds:**

Unsupported versions could be patched by adding the following configuration to run in production:

```yaml
sylius_channel:
    debug: false
```

#### Details

- [#10296](https://github.com/Sylius/Sylius/issues/10296) Product show page ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10342](https://github.com/Sylius/Sylius/issues/10342) [Fixture] Togglable default locale loading ([@lchrusciel](https://github.com/lchrusciel))
- [#10355](https://github.com/Sylius/Sylius/issues/10355) Adding a coupon generator command ([@mamazu](https://github.com/mamazu))
- [#10361](https://github.com/Sylius/Sylius/issues/10361) Change master branch to v1.6.0-DEV ([@pamil](https://github.com/pamil))
- [#10382](https://github.com/Sylius/Sylius/issues/10382) [Admin][Shipment] Add filtering shipments by a channel ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#10383](https://github.com/Sylius/Sylius/issues/10383) [Behat] Make feature filenames consistent with others ([@GSadee](https://github.com/GSadee))
- [#10388](https://github.com/Sylius/Sylius/issues/10388) Fix product show page margins ([@kulczy](https://github.com/kulczy))
- [#10391](https://github.com/Sylius/Sylius/issues/10391) [Admin][Product] Show page fixes ([@AdamKasp](https://github.com/AdamKasp))
- [#10392](https://github.com/Sylius/Sylius/issues/10392) improved code quality ([@oallain](https://github.com/oallain))
- [#10393](https://github.com/Sylius/Sylius/issues/10393) [Docs] Describe available configuration options for locale fixture ([@lchrusciel](https://github.com/lchrusciel))
- [#10396](https://github.com/Sylius/Sylius/issues/10396) [Admin] Avoid javascript in saving positions ([@Zales0123](https://github.com/Zales0123))
- [#10399](https://github.com/Sylius/Sylius/issues/10399) Add info into install command about need of setting the locale in symfony config ()
- [#10400](https://github.com/Sylius/Sylius/issues/10400) Add discounts and totals in the cart ([@kulczy](https://github.com/kulczy), [@bartoszpietrzak1994](https://github.com/bartoszpietrzak1994))
- [#10406](https://github.com/Sylius/Sylius/issues/10406) [Fixtures] Added random generated order complete date ([@AdamKasp](https://github.com/AdamKasp))
- [#10409](https://github.com/Sylius/Sylius/issues/10409) Create SECURITY.md ([@gabiudrescu](https://github.com/gabiudrescu), [@pamil](https://github.com/pamil))
- [#10417](https://github.com/Sylius/Sylius/issues/10417) [Admin] Order summary UI + discounts and taxes viewing logic ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10419](https://github.com/Sylius/Sylius/issues/10419) Add prices and discounts to the order summary box ([@kulczy](https://github.com/kulczy))
- [#10420](https://github.com/Sylius/Sylius/issues/10420) Change order summary table ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10429](https://github.com/Sylius/Sylius/issues/10429) Add admin user avatar placeholder ([@kulczy](https://github.com/kulczy))
- [#10438](https://github.com/Sylius/Sylius/issues/10438) Keep all prices in the same currency in checkout ([@pamil](https://github.com/pamil))
- [#10441](https://github.com/Sylius/Sylius/issues/10441) [Inventory][Product] Move inventory to new tab ([@AdamKasp](https://github.com/AdamKasp))
- [#10442](https://github.com/Sylius/Sylius/issues/10442) Add an alert about unsaved changes ([@kulczy](https://github.com/kulczy))
- [#10443](https://github.com/Sylius/Sylius/issues/10443) Unify shipping row on the order summary table ([@kulczy](https://github.com/kulczy))
- [#10444](https://github.com/Sylius/Sylius/issues/10444) Change dashboard view ([@kulczy](https://github.com/kulczy), [@pamil](https://github.com/pamil))
- [#10449](https://github.com/Sylius/Sylius/issues/10449) Administrator's avatar ([@Tomanhez](https://github.com/Tomanhez), [@Zales0123](https://github.com/Zales0123))
- [#10451](https://github.com/Sylius/Sylius/issues/10451) [Admin] Add possibility to configure custom index route in routing ([@GSadee](https://github.com/GSadee))
- [#10453](https://github.com/Sylius/Sylius/issues/10453) Fix deprecation notice ([@loevgaard](https://github.com/loevgaard))
- [#10455](https://github.com/Sylius/Sylius/issues/10455) Improve admin product show page UI ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#10456](https://github.com/Sylius/Sylius/issues/10456) Make image uploader easier to customize ([@Zales0123](https://github.com/Zales0123), [@pamil](https://github.com/pamil))
- [#10460](https://github.com/Sylius/Sylius/issues/10460) AvatarImage Doctrine mapping fix ([@bartoszpietrzak1994](https://github.com/bartoszpietrzak1994))
- [#10461](https://github.com/Sylius/Sylius/issues/10461) Fix product show page elements ([@kulczy](https://github.com/kulczy))
- [#10467](https://github.com/Sylius/Sylius/issues/10467) Drop support for Symfony 4.1 and 4.2 ([@pamil](https://github.com/pamil))
- [#10471](https://github.com/Sylius/Sylius/issues/10471) Add footer with Sylius version to the admin panel ([@kulczy](https://github.com/kulczy))
- [#10472](https://github.com/Sylius/Sylius/issues/10472) [Admin] Index of payments ([@Tomanhez](https://github.com/Tomanhez))
- [#10477](https://github.com/Sylius/Sylius/issues/10477) Improve bulk actions ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10482](https://github.com/Sylius/Sylius/issues/10482) [Promotion] Fix Action creation doc ([@pierre-H](https://github.com/pierre-H))
- [#10483](https://github.com/Sylius/Sylius/issues/10483) [Admin]Admin choose channel in product show page ([@Tomanhez](https://github.com/Tomanhez))
- [#10484](https://github.com/Sylius/Sylius/issues/10484) [Admin] Minor fixes payment shipment ([@Tomanhez](https://github.com/Tomanhez))
- [#10485](https://github.com/Sylius/Sylius/issues/10485) [Promotion] Coupon prefix and suffix ([@Zales0123](https://github.com/Zales0123))
- [#10491](https://github.com/Sylius/Sylius/issues/10491) [Admin] Form validation error  ([@Tomanhez](https://github.com/Tomanhez))
- [#10497](https://github.com/Sylius/Sylius/issues/10497) Minor Fixes - Admin choose channel in product show page ([@Tomanhez](https://github.com/Tomanhez))
- [#10499](https://github.com/Sylius/Sylius/issues/10499) [Admin] Fix css file ([@GSadee](https://github.com/GSadee))
- [#10510](https://github.com/Sylius/Sylius/issues/10510) Add avatar preview ([@kulczy](https://github.com/kulczy))
- [#10514](https://github.com/Sylius/Sylius/issues/10514) [Admin] In sections : edit variant and edit product add button product show page in shop ([@Tomanhez](https://github.com/Tomanhez))
- [#10516](https://github.com/Sylius/Sylius/issues/10516) Fix Psalm false-positives ([@pamil](https://github.com/pamil))
- [#10518](https://github.com/Sylius/Sylius/issues/10518) [Admin] Unify order link in Orders, Payments, Shipments ([@Tomanhez](https://github.com/Tomanhez))
- [#10520](https://github.com/Sylius/Sylius/issues/10520) [Admin] Unify payment and shipment labels ([@GSadee](https://github.com/GSadee))
- [#10521](https://github.com/Sylius/Sylius/issues/10521) [Admin][Product] Disable show in shop button when product is disabled ([@GSadee](https://github.com/GSadee))
- [#10522](https://github.com/Sylius/Sylius/issues/10522) Fix 'disabled' label ([@kulczy](https://github.com/kulczy))
- [#10529](https://github.com/Sylius/Sylius/issues/10529) [Fixtures] Improve fixtures. ([@AdamKasp](https://github.com/AdamKasp))
- [#10531](https://github.com/Sylius/Sylius/issues/10531) Improve filters UI ([@kulczy](https://github.com/kulczy))
- [#10534](https://github.com/Sylius/Sylius/issues/10534) [Fixtures] Variant name now is concatenated options value. ([@AdamKasp](https://github.com/AdamKasp))
- [#10536](https://github.com/Sylius/Sylius/issues/10536) [Docs] Make Plugins and Plugin Development Guide more visible ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10539](https://github.com/Sylius/Sylius/issues/10539) [Fixtures] Add tax category to product. ([@AdamKasp](https://github.com/AdamKasp))
- [#10541](https://github.com/Sylius/Sylius/issues/10541) Update README.md ([@AdamKasp](https://github.com/AdamKasp))
- [#10542](https://github.com/Sylius/Sylius/issues/10542) [Fixtures] Product fixtures in yaml. ([@AdamKasp](https://github.com/AdamKasp))
- [#10546](https://github.com/Sylius/Sylius/issues/10546) Improve filters ([@kulczy](https://github.com/kulczy))
- [#10547](https://github.com/Sylius/Sylius/issues/10547) [Admin] Remove avatar ([@Tomanhez](https://github.com/Tomanhez))
- [#10552](https://github.com/Sylius/Sylius/issues/10552) [Order] Change OrderItemController methods to protected ([@Zales0123](https://github.com/Zales0123))
- [#10555](https://github.com/Sylius/Sylius/issues/10555) [Admin][AdminUser] Improvements for removing an avatar ([@GSadee](https://github.com/GSadee))
- [#10560](https://github.com/Sylius/Sylius/issues/10560) [Behat][AdminUser] Fix filename typo ([@GSadee](https://github.com/GSadee))
- [#10562](https://github.com/Sylius/Sylius/issues/10562) Avoid js when removing product from cart ([@Zales0123](https://github.com/Zales0123))
- [#10570](https://github.com/Sylius/Sylius/issues/10570) [Fixtures] Added 'tracked' field to product fixture configuration ([@AdamKasp](https://github.com/AdamKasp))
- [#10572](https://github.com/Sylius/Sylius/issues/10572) [Fixtures] Minor fixes. ([@AdamKasp](https://github.com/AdamKasp))
- [#10576](https://github.com/Sylius/Sylius/issues/10576) [Fixtures] Jeans attributes names fix ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10580](https://github.com/Sylius/Sylius/issues/10580) [Admin][Order] Change item to unit discount on summary page ([@GSadee](https://github.com/GSadee))
- [#10587](https://github.com/Sylius/Sylius/issues/10587) Avoid BC break in ProductExampleFactory ([@Zales0123](https://github.com/Zales0123))
- [#10588](https://github.com/Sylius/Sylius/issues/10588) [AdminBundle] Payments & Shipments index pages sortable by date ([@Tomanhez](https://github.com/Tomanhez))
- [#10594](https://github.com/Sylius/Sylius/issues/10594) [CoreBundle] Fixtures creating SimpleProduct, remove options from caps ([@Tomanhez](https://github.com/Tomanhez))
- [#10595](https://github.com/Sylius/Sylius/issues/10595) Use {{ limit }} to allow min/max value update ([@Prometee](https://github.com/Prometee))
- [#10596](https://github.com/Sylius/Sylius/issues/10596) [Documentation][Contribution] Improve doc contribution guide ([@lchrusciel](https://github.com/lchrusciel))
- [#10597](https://github.com/Sylius/Sylius/issues/10597) [AdminBundle] Extract logo to separate twig file ([@Tomanhez](https://github.com/Tomanhez))
- [#10606](https://github.com/Sylius/Sylius/issues/10606) [Admin][Payment] Not displaying payments in cart state on the list ([@GSadee](https://github.com/GSadee))
- [#10614](https://github.com/Sylius/Sylius/issues/10614) [AdminBundle] Uncoupled AdminBundle with ShopBundle ([@Tomanhez](https://github.com/Tomanhez))
- [#10615](https://github.com/Sylius/Sylius/issues/10615) [HOTFIX] [Behat] Fix tax extraction ([@lchrusciel](https://github.com/lchrusciel))
- [#10616](https://github.com/Sylius/Sylius/issues/10616) [Fixture] Make order fixture more flexible ([@TiMESPLiNTER](https://github.com/TiMESPLiNTER), [@AdamKasp](https://github.com/AdamKasp))
- [#10617](https://github.com/Sylius/Sylius/issues/10617) Provide an upgrade guide for v1.6.0 ([@pamil](https://github.com/pamil))
- [#10619](https://github.com/Sylius/Sylius/issues/10619) Sending email  after ship shipment on grid ([@AdamKasp](https://github.com/AdamKasp))
- [#10620](https://github.com/Sylius/Sylius/issues/10620) Fix bug after rebase ([@AdamKasp](https://github.com/AdamKasp))
- [#10621](https://github.com/Sylius/Sylius/issues/10621) Fix email after complete payment via grid ([@AdamKasp](https://github.com/AdamKasp))
- [#10627](https://github.com/Sylius/Sylius/issues/10627) Use fallback locale as default for the new administrators ([@pamil](https://github.com/pamil))
- [#10628](https://github.com/Sylius/Sylius/issues/10628) Fix OrderExampleFactory ([@Zales0123](https://github.com/Zales0123))
- [#10630](https://github.com/Sylius/Sylius/issues/10630) [HotFix] Proper order of arguments ([@lchrusciel](https://github.com/lchrusciel))
- [#10631](https://github.com/Sylius/Sylius/issues/10631) [Core] Improved fixture example factory ([@lchrusciel](https://github.com/lchrusciel))
- [#10636](https://github.com/Sylius/Sylius/issues/10636) [Admin] Proper tests for shipment mailing ([@lchrusciel](https://github.com/lchrusciel))
- [#10639](https://github.com/Sylius/Sylius/issues/10639) [Admin] Fix sorting on customer orders list ([@lchrusciel](https://github.com/lchrusciel))
- [#10640](https://github.com/Sylius/Sylius/issues/10640) Revert "[Admin][Shipment] Add filtering shipments by a channel" ([@lchrusciel](https://github.com/lchrusciel))
- [#10642](https://github.com/Sylius/Sylius/issues/10642) [Admin][Shipment] Add filtering shipments by a channel ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#10695](https://github.com/Sylius/Sylius/issues/10695) [Admin][Product] Fix displayed stocks on product show page ([@GSadee](https://github.com/GSadee))
- [#10700](https://github.com/Sylius/Sylius/issues/10700) [Promotion] Remove coupling to core ([@lchrusciel](https://github.com/lchrusciel))
- [#10716](https://github.com/Sylius/Sylius/issues/10716) Minor fixtures fixes ([@AdamKasp](https://github.com/AdamKasp))
- [#10733](https://github.com/Sylius/Sylius/issues/10733) Fix 10719 infinite order fixture loading ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#10744](https://github.com/Sylius/Sylius/issues/10744) [Documentation][Book] Invoices ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10747](https://github.com/Sylius/Sylius/issues/10747) Remove flashing from the bulk button ([@kulczy](https://github.com/kulczy))
- [#10760](https://github.com/Sylius/Sylius/issues/10760) Add JQuery Dirtyforms in UPGRADE-1.6.md ([@maximehuran](https://github.com/maximehuran))
- [#10784](https://github.com/Sylius/Sylius/issues/10784) [Docs] Installation guide update ([@lchrusciel](https://github.com/lchrusciel))
- [#10837](https://github.com/Sylius/Sylius/issues/10837) Remove unused templating engine from RemoveAvatarAction ([@pamil](https://github.com/pamil))
- [#10842](https://github.com/Sylius/Sylius/issues/10842) [Docs] Update core team ([@lchrusciel](https://github.com/lchrusciel))
- [#10844](https://github.com/Sylius/Sylius/issues/10844) Clarify BC promise for final controllers ([@pamil](https://github.com/pamil))
- [#10853](https://github.com/Sylius/Sylius/issues/10853) [Behat][Admin][Order] Fix scenarios for displaying promotions on 1.6 after upmerge ([@GSadee](https://github.com/GSadee))
- [#10865](https://github.com/Sylius/Sylius/issues/10865) [Admin][Promotion] Fix the prevention of generating too many coupons ([@GSadee](https://github.com/GSadee))
- [#10884](https://github.com/Sylius/Sylius/issues/10884) [Plugins][Docs] Plugin technical requirements changes ([@Zales0123](https://github.com/Zales0123))
- [#10889](https://github.com/Sylius/Sylius/issues/10889) [Fixtures] Update product names ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10890](https://github.com/Sylius/Sylius/issues/10890) Fix build - remove redundant validation message part ([@Zales0123](https://github.com/Zales0123))
- [#11046](https://github.com/Sylius/Sylius/issues/11046) [Docs] Update sensio.sphinx ([@Tomanhez](https://github.com/Tomanhez))
- [#11060](https://github.com/Sylius/Sylius/issues/11060) Fixed typo in services comment ([@codreanulaurentiu](https://github.com/codreanulaurentiu))
- [#11061](https://github.com/Sylius/Sylius/issues/11061) [Documentation] Backport of #11054 to 1.6 ([@lchrusciel](https://github.com/lchrusciel))

## v1.6.3, v1.6.4 (2019-12-03, 2019-12-05)

#### CVE-2019-16768: Internal exception message exposure in login action.

**Details:**

Exception messages from internal exceptions (like database exception) are wrapped by 
`\Symfony\Component\Security\Core\Exception\AuthenticationServiceException` and propagated through the system to UI. 
Therefore, some internal system information may leak and be visible to the customer.

A validation message with the exception details will be presented to the user when one will try to log into the shop.

**Solution:**

This release patches the reported vulnerability. The `src/Sylius/Bundle/UiBundle/Resources/views/Security/_login.html.twig` 
file from Sylius should be overridden and `{{ messages.error(last_error.message) }}` changed to `{{ messages.error(last_error.messageKey) }}`.

#### Details

- [#10835](https://github.com/Sylius/Sylius/issues/10835) Improve deprecation message for "Sylius\Bundle\CoreBundle\Application\Kernel" ([@pamil](https://github.com/pamil))
- [#10837](https://github.com/Sylius/Sylius/issues/10837) Remove unused templating engine from RemoveAvatarAction ([@pamil](https://github.com/pamil))
- [#10841](https://github.com/Sylius/Sylius/issues/10841) [Docs] Include link to ShopApi docs to REST API Reference ([@Zales0123](https://github.com/Zales0123))
- [#10842](https://github.com/Sylius/Sylius/issues/10842) [Docs] Update core team ([@lchrusciel](https://github.com/lchrusciel))
- [#10844](https://github.com/Sylius/Sylius/issues/10844) Clarify BC promise for final controllers ([@pamil](https://github.com/pamil))
- [#10846](https://github.com/Sylius/Sylius/issues/10846) [Order] Include order unit promotion adjustments and order item promotion adjustments in order promotion total ([@Tomanhez](https://github.com/Tomanhez))
- [#10849](https://github.com/Sylius/Sylius/issues/10849) Move ShopApi reference to main menu ([@Zales0123](https://github.com/Zales0123))
- [#10853](https://github.com/Sylius/Sylius/issues/10853) [Behat][Admin][Order] Fix scenarios for displaying promotions on 1.6 after upmerge ([@GSadee](https://github.com/GSadee))
- [#10855](https://github.com/Sylius/Sylius/issues/10855) [Docs] Open external links in a new tab ([@Zales0123](https://github.com/Zales0123))
- [#10857](https://github.com/Sylius/Sylius/issues/10857) Change readme banner ([@kulczy](https://github.com/kulczy))
- [#10865](https://github.com/Sylius/Sylius/issues/10865) [Admin][Promotion] Fix the prevention of generating too many coupons ([@GSadee](https://github.com/GSadee))
- [#10880](https://github.com/Sylius/Sylius/issues/10880) [Promotion] Improve coupon generation validation message ([@GSadee](https://github.com/GSadee))
- [#10881](https://github.com/Sylius/Sylius/issues/10881) Add docs banner ([@kulczy](https://github.com/kulczy))
- [#10889](https://github.com/Sylius/Sylius/issues/10889) [Fixtures] Update product names ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10890](https://github.com/Sylius/Sylius/issues/10890) Fix build - remove redundant validation message part ([@Zales0123](https://github.com/Zales0123))
- [#10891](https://github.com/Sylius/Sylius/issues/10891) Update release process docs for 1.2 ([@pamil](https://github.com/pamil))

## v1.6.2 (2019-11-11)

#### Details

- [#9931](https://github.com/Sylius/Sylius/issues/9931) [Payum] infinite loop on state machine exception fixed ([@tautelis](https://github.com/tautelis))
- [#10733](https://github.com/Sylius/Sylius/issues/10733) Fix 10719 infinite order fixture loading ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#10734](https://github.com/Sylius/Sylius/issues/10734) Added: TimestampableInterface to core TaxonInterface (fixes #10728) ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#10744](https://github.com/Sylius/Sylius/issues/10744) [Documentation][Book] Invoices ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10748](https://github.com/Sylius/Sylius/issues/10748) Switch statement conditions ([@mikemix](https://github.com/mikemix))
- [#10750](https://github.com/Sylius/Sylius/issues/10750) Fix compound form errors ([@loic425](https://github.com/loic425))
- [#10752](https://github.com/Sylius/Sylius/issues/10752) Translate attribute type on attributes grid ([@loic425](https://github.com/loic425))
- [#10755](https://github.com/Sylius/Sylius/issues/10755) [Docs] Add tag that stripe is outdated and add SCA note ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#10760](https://github.com/Sylius/Sylius/issues/10760) Add JQuery Dirtyforms in UPGRADE-1.6.md ([@maximehuran](https://github.com/maximehuran))
- [#10761](https://github.com/Sylius/Sylius/issues/10761) Replace EntityManager#flush($entity) by EntityManager#flush() ([@twojtylak](https://github.com/twojtylak))
- [#10764](https://github.com/Sylius/Sylius/issues/10764) [Behat] Fix a typo on Paypal context ([@loic425](https://github.com/loic425))
- [#10769](https://github.com/Sylius/Sylius/issues/10769) Remove unsupported RBAC plugin from command and docs ([@GSadee](https://github.com/GSadee))
- [#10773](https://github.com/Sylius/Sylius/issues/10773) Update ad url ([@kulczy](https://github.com/kulczy))
- [#10776](https://github.com/Sylius/Sylius/issues/10776) [Behat] Remove final on product index and product variant index pages ([@loic425](https://github.com/loic425))
- [#10781](https://github.com/Sylius/Sylius/issues/10781) Allow no default tax zone in channel fixtures ([@pamil](https://github.com/pamil))
- [#10784](https://github.com/Sylius/Sylius/issues/10784) [Docs] Installation guide update ([@lchrusciel](https://github.com/lchrusciel))
- [#10790](https://github.com/Sylius/Sylius/issues/10790) [ShippingMethod] Do not allow to specify shipping charge below 0 ([@Zales0123](https://github.com/Zales0123))
- [#10792](https://github.com/Sylius/Sylius/issues/10792) [Behat][Admin] Add scenarios for validating default locale for a channel ([@GSadee](https://github.com/GSadee))
- [#10793](https://github.com/Sylius/Sylius/issues/10793) [Admin][Channel] Validating default locale for a channel ([@GSadee](https://github.com/GSadee))
- [#10805](https://github.com/Sylius/Sylius/issues/10805) [Addressing] Make sure the CountryNameExtension::translateCountryIsoCode() always returns a string ([@vvasiloi](https://github.com/vvasiloi))
- [#10806](https://github.com/Sylius/Sylius/issues/10806) [Order] include order promotion adjustments in order promotion total ([@vvasiloi](https://github.com/vvasiloi))
- [#10819](https://github.com/Sylius/Sylius/issues/10819) Fixed: Typo/artifact ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#10820](https://github.com/Sylius/Sylius/issues/10820) Rename shop user factory to help autowiring ([@loic425](https://github.com/loic425))
- [#10821](https://github.com/Sylius/Sylius/issues/10821) Specify PHP version for SymfonyInsights ([@pamil](https://github.com/pamil))
- [#10823](https://github.com/Sylius/Sylius/issues/10823) Remove unnecessary +x chmod on some files ([@pamil](https://github.com/pamil))
- [#10824](https://github.com/Sylius/Sylius/issues/10824) Use SessionInterface instead of Session in UserImpersonator ([@pamil](https://github.com/pamil))
- [#10825](https://github.com/Sylius/Sylius/issues/10825) Fixed: Typo at grid configuration example ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#10826](https://github.com/Sylius/Sylius/issues/10826) Execute PHPUnit tests inside AdminApiBundle ([@pamil](https://github.com/pamil))
- [#10832](https://github.com/Sylius/Sylius/issues/10832) Do not merge promotion action configuration ([@pamil](https://github.com/pamil))

## v1.6.1 (2019-10-08)

#### Details

- [#10641](https://github.com/Sylius/Sylius/issues/10641) [Documentation] Fixtures customization guides - fixes ([@CoderMaggie](https://github.com/CoderMaggie), [@Zales0123](https://github.com/Zales0123))
- [#10644](https://github.com/Sylius/Sylius/issues/10644) [Documentation] Add tip about locked adjustments ([@j0r1s](https://github.com/j0r1s))
- [#10645](https://github.com/Sylius/Sylius/issues/10645) [Docs] Fix Blackfire Ad ([@Tomanhez](https://github.com/Tomanhez))
- [#10646](https://github.com/Sylius/Sylius/issues/10646) [Docs] Fix Ad ([@Tomanhez](https://github.com/Tomanhez))
- [#10649](https://github.com/Sylius/Sylius/issues/10649) Update online course ad ([@kulczy](https://github.com/kulczy))
- [#10652](https://github.com/Sylius/Sylius/issues/10652) Add Sylius 1.6 banner to the docs ([@kulczy](https://github.com/kulczy))
- [#10667](https://github.com/Sylius/Sylius/issues/10667) Improve GUS information notification ([@Zales0123](https://github.com/Zales0123))
- [#10680](https://github.com/Sylius/Sylius/issues/10680) Fix ChannelCollector related serialization issue in Symfony profiler ([@ostrolucky](https://github.com/ostrolucky))
- [#10695](https://github.com/Sylius/Sylius/issues/10695) [Admin][Product] Fix displayed stocks on product show page ([@GSadee](https://github.com/GSadee))
- [#10700](https://github.com/Sylius/Sylius/issues/10700) [Promotion] Remove coupling to core ([@lchrusciel](https://github.com/lchrusciel))
- [#10701](https://github.com/Sylius/Sylius/issues/10701) [Maintenance] Update docs with v1.6 ([@lchrusciel](https://github.com/lchrusciel))
- [#10710](https://github.com/Sylius/Sylius/issues/10710) [Address book] Extensibility improvements ([@cyrosy](https://github.com/cyrosy))
- [#10713](https://github.com/Sylius/Sylius/issues/10713) [Behat] Improve dashboard page extensibility ([@loic425](https://github.com/loic425))
- [#10716](https://github.com/Sylius/Sylius/issues/10716) Minor fixtures fixes ([@AdamKasp](https://github.com/AdamKasp))
- [#10727](https://github.com/Sylius/Sylius/issues/10727) Fix channels label size and alignment ([@kulczy](https://github.com/kulczy))
- [#10732](https://github.com/Sylius/Sylius/issues/10732) Update course ad ([@kulczy](https://github.com/kulczy))
- [#10739](https://github.com/Sylius/Sylius/issues/10739) [Admin][Adressing] fixed province code validation regex ([@twojtylak](https://github.com/twojtylak))
- [#10742](https://github.com/Sylius/Sylius/issues/10742) Fix the build for 1.5 and 1.6 branches ([@pamil](https://github.com/pamil))
- [#10747](https://github.com/Sylius/Sylius/issues/10747) Remove flashing from the bulk button ([@kulczy](https://github.com/kulczy))

## v1.6.0 (2019-08-29)

#### Details

- [#10382](https://github.com/Sylius/Sylius/issues/10382) [Admin][Shipment] Add filtering shipments by a channel ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#10636](https://github.com/Sylius/Sylius/issues/10636) [Admin] Proper tests for shipment mailing ([@lchrusciel](https://github.com/lchrusciel))
- [#10639](https://github.com/Sylius/Sylius/issues/10639) [Admin] Fix sorting on customer orders list ([@lchrusciel](https://github.com/lchrusciel))

## v1.6.0-RC.1 (2019-08-27)

#### Details

- [#10395](https://github.com/Sylius/Sylius/issues/10395) [Docs] How to add your custom fixtures? ([@Tomanhez](https://github.com/Tomanhez))
- [#10397](https://github.com/Sylius/Sylius/issues/10397) [Docs]How to add your custom fixture suites? ([@Tomanhez](https://github.com/Tomanhez))
- [#10456](https://github.com/Sylius/Sylius/issues/10456) Make image uploader easier to customize ([@Zales0123](https://github.com/Zales0123), [@pamil](https://github.com/pamil))
- [#10512](https://github.com/Sylius/Sylius/issues/10512) [Admin] Improve breadcrumbs (especially for ProductVariants and PromotionCoupons) ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10540](https://github.com/Sylius/Sylius/issues/10540) Skip oauth_user_factory_is_not_overridden test if HWIOAuthBundle is not installed ([@vvasiloi](https://github.com/vvasiloi))
- [#10547](https://github.com/Sylius/Sylius/issues/10547) [Admin] Remove avatar ([@Tomanhez](https://github.com/Tomanhez))
- [#10552](https://github.com/Sylius/Sylius/issues/10552) [Order] Change OrderItemController methods to protected ([@Zales0123](https://github.com/Zales0123))
- [#10553](https://github.com/Sylius/Sylius/issues/10553) Flags are not languages ([@vvasiloi](https://github.com/vvasiloi))
- [#10555](https://github.com/Sylius/Sylius/issues/10555) [Admin][AdminUser] Improvements for removing an avatar ([@GSadee](https://github.com/GSadee))
- [#10558](https://github.com/Sylius/Sylius/issues/10558) Allow translation of custom labels ([@Prometee](https://github.com/Prometee))
- [#10560](https://github.com/Sylius/Sylius/issues/10560) [Behat][AdminUser] Fix filename typo ([@GSadee](https://github.com/GSadee))
- [#10562](https://github.com/Sylius/Sylius/issues/10562) Avoid js when removing product from cart ([@Zales0123](https://github.com/Zales0123))
- [#10564](https://github.com/Sylius/Sylius/issues/10564) [Fixture] Improve order fixture ([@Zales0123](https://github.com/Zales0123))
- [#10570](https://github.com/Sylius/Sylius/issues/10570) [Fixtures] Added 'tracked' field to product fixture configuration ([@AdamKasp](https://github.com/AdamKasp))
- [#10571](https://github.com/Sylius/Sylius/issues/10571) Update custom-promotion-rule.rst ([@jmwill86](https://github.com/jmwill86))
- [#10572](https://github.com/Sylius/Sylius/issues/10572) [Fixtures] Minor fixes. ([@AdamKasp](https://github.com/AdamKasp))
- [#10576](https://github.com/Sylius/Sylius/issues/10576) [Fixtures] Jeans attributes names fix ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10579](https://github.com/Sylius/Sylius/issues/10579) Fix lazy choice tree will not automatically expanded ([@tom10271](https://github.com/tom10271))
- [#10580](https://github.com/Sylius/Sylius/issues/10580) [Admin][Order] Change item to unit discount on summary page ([@GSadee](https://github.com/GSadee))
- [#10583](https://github.com/Sylius/Sylius/issues/10583) Enable sorting of customer orders in admin panel ([@pamil](https://github.com/pamil))
- [#10587](https://github.com/Sylius/Sylius/issues/10587) Avoid BC break in ProductExampleFactory ([@Zales0123](https://github.com/Zales0123))
- [#10588](https://github.com/Sylius/Sylius/issues/10588) [AdminBundle] Payments & Shipments index pages sortable by date ([@Tomanhez](https://github.com/Tomanhez))
- [#10589](https://github.com/Sylius/Sylius/issues/10589) [Documentation][Cookbook] How to integrate a Payment Gateway as a Plugin? ([@lchrusciel](https://github.com/lchrusciel))
- [#10594](https://github.com/Sylius/Sylius/issues/10594) [CoreBundle] Fixtures creating SimpleProduct, remove options from caps ([@Tomanhez](https://github.com/Tomanhez))
- [#10595](https://github.com/Sylius/Sylius/issues/10595) Use {{ limit }} to allow min/max value update ([@Prometee](https://github.com/Prometee))
- [#10596](https://github.com/Sylius/Sylius/issues/10596) [Documentation][Contribution] Improve doc contribution guide ([@lchrusciel](https://github.com/lchrusciel))
- [#10597](https://github.com/Sylius/Sylius/issues/10597) [AdminBundle] Extract logo to separate twig file ([@Tomanhez](https://github.com/Tomanhez))
- [#10598](https://github.com/Sylius/Sylius/issues/10598) Add course ad ([@kulczy](https://github.com/kulczy))
- [#10599](https://github.com/Sylius/Sylius/issues/10599) [Documentation] Delete additional lines to remove ShopBundle ([@wpje](https://github.com/wpje))
- [#10600](https://github.com/Sylius/Sylius/issues/10600) [Documentation][Minor] Removing redundant dots ([@lchrusciel](https://github.com/lchrusciel))
- [#10601](https://github.com/Sylius/Sylius/issues/10601) Change course CTA ([@kulczy](https://github.com/kulczy))
- [#10603](https://github.com/Sylius/Sylius/issues/10603) [Shop] Promotion integrity checker fix ([@lchrusciel](https://github.com/lchrusciel))
- [#10605](https://github.com/Sylius/Sylius/issues/10605) [Admin][Shipment] Not displaying shipments in cart state on the list ([@GSadee](https://github.com/GSadee))
- [#10606](https://github.com/Sylius/Sylius/issues/10606) [Admin][Payment] Not displaying payments in cart state on the list ([@GSadee](https://github.com/GSadee))
- [#10608](https://github.com/Sylius/Sylius/issues/10608) [Docs] Fix incorrect documentation regarding payments ([@dimaip](https://github.com/dimaip))
- [#10609](https://github.com/Sylius/Sylius/issues/10609) [Documentation][Minor] Proper comment in xml file ([@lchrusciel](https://github.com/lchrusciel))
- [#10613](https://github.com/Sylius/Sylius/issues/10613) [PayumBundle] Use Payment amount in Payum gateways actions (, [@Zales0123](https://github.com/Zales0123))
- [#10614](https://github.com/Sylius/Sylius/issues/10614) [AdminBundle] Uncoupled AdminBundle with ShopBundle ([@Tomanhez](https://github.com/Tomanhez))
- [#10615](https://github.com/Sylius/Sylius/issues/10615) [HOTFIX] [Behat] Fix tax extraction ([@lchrusciel](https://github.com/lchrusciel))
- [#10616](https://github.com/Sylius/Sylius/issues/10616) [Fixture] Make order fixture more flexible ([@TiMESPLiNTER](https://github.com/TiMESPLiNTER), [@AdamKasp](https://github.com/AdamKasp))
- [#10617](https://github.com/Sylius/Sylius/issues/10617) Provide an upgrade guide for v1.6.0 ([@pamil](https://github.com/pamil))
- [#10618](https://github.com/Sylius/Sylius/issues/10618) [Fixtures] Allow no shipping and payments in fixtures ([@igormukhingmailcom](https://github.com/igormukhingmailcom), [@Zales0123](https://github.com/Zales0123))
- [#10619](https://github.com/Sylius/Sylius/issues/10619) Sending email  after ship shipment on grid ([@AdamKasp](https://github.com/AdamKasp))
- [#10620](https://github.com/Sylius/Sylius/issues/10620) Fix bug after rebase ([@AdamKasp](https://github.com/AdamKasp))
- [#10621](https://github.com/Sylius/Sylius/issues/10621) Fix email after complete payment via grid ([@AdamKasp](https://github.com/AdamKasp))
- [#10624](https://github.com/Sylius/Sylius/issues/10624) Disable chrome autocomplete ([@kulczy](https://github.com/kulczy))
- [#10626](https://github.com/Sylius/Sylius/issues/10626) [Fixture] Do not skip payments and shipments manually ([@Zales0123](https://github.com/Zales0123))
- [#10627](https://github.com/Sylius/Sylius/issues/10627) Use fallback locale as default for the new administrators ([@pamil](https://github.com/pamil))
- [#10628](https://github.com/Sylius/Sylius/issues/10628) Fix OrderExampleFactory ([@Zales0123](https://github.com/Zales0123))
- [#10629](https://github.com/Sylius/Sylius/issues/10629) [Docs] Add missing items to customization guide menu ([@Zales0123](https://github.com/Zales0123))
- [#10630](https://github.com/Sylius/Sylius/issues/10630) [HotFix] Proper order of arguments ([@lchrusciel](https://github.com/lchrusciel))
- [#10631](https://github.com/Sylius/Sylius/issues/10631) [Core] Improved fixture example factory ([@lchrusciel](https://github.com/lchrusciel))
- [#10633](https://github.com/Sylius/Sylius/issues/10633) Add Blackfire ad ([@kulczy](https://github.com/kulczy))
- [#10634](https://github.com/Sylius/Sylius/issues/10634) Add Blackfire logo ([@kulczy](https://github.com/kulczy))

## v1.6.0-ALPHA.2 (2019-07-25)

#### Details

- [#10165](https://github.com/Sylius/Sylius/issues/10165) Product attribute fixtures improvements ([@Zales0123](https://github.com/Zales0123), [@pamil](https://github.com/pamil))
- [#10401](https://github.com/Sylius/Sylius/issues/10401) Psalm ([@loic425](https://github.com/loic425), [@pamil](https://github.com/pamil))
- [#10464](https://github.com/Sylius/Sylius/issues/10464) Do not crash when duplicated locales are passed to the fixture ([@pamil](https://github.com/pamil))
- [#10467](https://github.com/Sylius/Sylius/issues/10467) Drop support for Symfony 4.1 and 4.2 ([@pamil](https://github.com/pamil))
- [#10468](https://github.com/Sylius/Sylius/issues/10468) Remove Symfony workarounds and add conflicts ([@pamil](https://github.com/pamil))
- [#10471](https://github.com/Sylius/Sylius/issues/10471) Add footer with Sylius version to the admin panel ([@kulczy](https://github.com/kulczy))
- [#10472](https://github.com/Sylius/Sylius/issues/10472) [Admin] Index of payments ([@Tomanhez](https://github.com/Tomanhez))
- [#10473](https://github.com/Sylius/Sylius/issues/10473) Update docs to follow Symfony 4 standards ([@pamil](https://github.com/pamil))
- [#10477](https://github.com/Sylius/Sylius/issues/10477) Improve bulk actions ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10482](https://github.com/Sylius/Sylius/issues/10482) [Promotion] Fix Action creation doc ([@pierre-H](https://github.com/pierre-H))
- [#10483](https://github.com/Sylius/Sylius/issues/10483) [Admin]Admin choose channel in product show page ([@Tomanhez](https://github.com/Tomanhez))
- [#10484](https://github.com/Sylius/Sylius/issues/10484) [Admin] Minor fixes payment shipment ([@Tomanhez](https://github.com/Tomanhez))
- [#10485](https://github.com/Sylius/Sylius/issues/10485) [Promotion] Coupon prefix and suffix ([@Zales0123](https://github.com/Zales0123))
- [#10488](https://github.com/Sylius/Sylius/issues/10488) Marked router dependency as deprecated in admin ImpersonateUserController ([@SebLours](https://github.com/SebLours))
- [#10489](https://github.com/Sylius/Sylius/issues/10489) Make it possible to have no shipping methods for Order fixtures ([@TiMESPLiNTER](https://github.com/TiMESPLiNTER))
- [#10491](https://github.com/Sylius/Sylius/issues/10491) [Admin] Form validation error  ([@Tomanhez](https://github.com/Tomanhez))
- [#10492](https://github.com/Sylius/Sylius/issues/10492) [Admin] Minor fixes customer group validation form ([@Tomanhez](https://github.com/Tomanhez))
- [#10494](https://github.com/Sylius/Sylius/issues/10494) [UI] Fix button groups radius ([@kulczy](https://github.com/kulczy))
- [#10496](https://github.com/Sylius/Sylius/issues/10496) [UPGRADE] Mention locale requirement change in UPGRADE-1.5 ([@Zales0123](https://github.com/Zales0123))
- [#10497](https://github.com/Sylius/Sylius/issues/10497) Minor Fixes - Admin choose channel in product show page ([@Tomanhez](https://github.com/Tomanhez))
- [#10498](https://github.com/Sylius/Sylius/issues/10498) Add search bar css rule for Firefox ([@aloupfor](https://github.com/aloupfor))
- [#10499](https://github.com/Sylius/Sylius/issues/10499) [Admin] Fix css file ([@GSadee](https://github.com/GSadee))
- [#10508](https://github.com/Sylius/Sylius/issues/10508) Revert "Make it possible to have no shipping methods for Order fixtures" ([@lchrusciel](https://github.com/lchrusciel))
- [#10509](https://github.com/Sylius/Sylius/issues/10509) [Admin] Add link to product in variant breadcrumb ([@Tomanhez](https://github.com/Tomanhez))
- [#10510](https://github.com/Sylius/Sylius/issues/10510) Add avatar preview ([@kulczy](https://github.com/kulczy))
- [#10514](https://github.com/Sylius/Sylius/issues/10514) [Admin] In sections : edit variant and edit product add button product show page in shop ([@Tomanhez](https://github.com/Tomanhez))
- [#10516](https://github.com/Sylius/Sylius/issues/10516) Fix Psalm false-positives ([@pamil](https://github.com/pamil))
- [#10517](https://github.com/Sylius/Sylius/issues/10517) [Grid] Allow not to pass "apply_transition" button class ([@Zales0123](https://github.com/Zales0123))
- [#10518](https://github.com/Sylius/Sylius/issues/10518) [Admin] Unify order link in Orders, Payments, Shipments ([@Tomanhez](https://github.com/Tomanhez))
- [#10520](https://github.com/Sylius/Sylius/issues/10520) [Admin] Unify payment and shipment labels ([@GSadee](https://github.com/GSadee))
- [#10521](https://github.com/Sylius/Sylius/issues/10521) [Admin][Product] Disable show in shop button when product is disabled ([@GSadee](https://github.com/GSadee))
- [#10522](https://github.com/Sylius/Sylius/issues/10522) Fix 'disabled' label ([@kulczy](https://github.com/kulczy))
- [#10525](https://github.com/Sylius/Sylius/issues/10525) Bump lodash from 4.17.11 to 4.17.14 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#10529](https://github.com/Sylius/Sylius/issues/10529) [Fixtures] Improve fixtures. ([@AdamKasp](https://github.com/AdamKasp))
- [#10531](https://github.com/Sylius/Sylius/issues/10531) Improve filters UI ([@kulczy](https://github.com/kulczy))
- [#10534](https://github.com/Sylius/Sylius/issues/10534) [Fixtures] Variant name now is concatenated options value. ([@AdamKasp](https://github.com/AdamKasp))
- [#10535](https://github.com/Sylius/Sylius/issues/10535) [Shop] Fix passed channel context service to be composite ([@GSadee](https://github.com/GSadee))
- [#10536](https://github.com/Sylius/Sylius/issues/10536) [Docs] Make Plugins and Plugin Development Guide more visible ([@CoderMaggie](https://github.com/CoderMaggie))
- [#10539](https://github.com/Sylius/Sylius/issues/10539) [Fixtures] Add tax category to product. ([@AdamKasp](https://github.com/AdamKasp))
- [#10541](https://github.com/Sylius/Sylius/issues/10541) Update README.md ([@AdamKasp](https://github.com/AdamKasp))
- [#10542](https://github.com/Sylius/Sylius/issues/10542) [Fixtures] Product fixtures in yaml. ([@AdamKasp](https://github.com/AdamKasp))
- [#10546](https://github.com/Sylius/Sylius/issues/10546) Improve filters ([@kulczy](https://github.com/kulczy))
- [#10548](https://github.com/Sylius/Sylius/issues/10548) [HotFix?] Move mysql service to fix the build ([@Zales0123](https://github.com/Zales0123))

## v1.6.0-ALPHA.1 (2019-06-20)

#### Details

- [#10296](https://github.com/Sylius/Sylius/issues/10296) Product show page ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10342](https://github.com/Sylius/Sylius/issues/10342) [Fixture] Togglable default locale loading ([@lchrusciel](https://github.com/lchrusciel))
- [#10355](https://github.com/Sylius/Sylius/issues/10355) Adding a coupon generator command ([@mamazu](https://github.com/mamazu))
- [#10361](https://github.com/Sylius/Sylius/issues/10361) Change master branch to v1.6.0-DEV ([@pamil](https://github.com/pamil))
- [#10383](https://github.com/Sylius/Sylius/issues/10383) [Behat] Make feature filenames consistent with others ([@GSadee](https://github.com/GSadee))
- [#10388](https://github.com/Sylius/Sylius/issues/10388) Fix product show page margins ([@kulczy](https://github.com/kulczy))
- [#10391](https://github.com/Sylius/Sylius/issues/10391) [Admin][Product] Show page fixes ([@AdamKasp](https://github.com/AdamKasp))
- [#10392](https://github.com/Sylius/Sylius/issues/10392) improved code quality ([@oallain](https://github.com/oallain))
- [#10393](https://github.com/Sylius/Sylius/issues/10393) [Docs] Describe available configuration options for locale fixture ([@lchrusciel](https://github.com/lchrusciel))
- [#10396](https://github.com/Sylius/Sylius/issues/10396) [Admin] Avoid javascript in saving positions ([@Zales0123](https://github.com/Zales0123))
- [#10399](https://github.com/Sylius/Sylius/issues/10399) Add info into install command about need of setting the locale in symfony config ([@Holicz](https://github.com/Holicz))
- [#10400](https://github.com/Sylius/Sylius/issues/10400) Add discounts and totals in the cart ([@kulczy](https://github.com/kulczy), [@bartoszpietrzak1994](https://github.com/bartoszpietrzak1994))
- [#10406](https://github.com/Sylius/Sylius/issues/10406) [Fixtures] Added random generated order complete date ([@AdamKasp](https://github.com/AdamKasp))
- [#10409](https://github.com/Sylius/Sylius/issues/10409) Create SECURITY.md ([@gabiudrescu](https://github.com/gabiudrescu), [@pamil](https://github.com/pamil))
- [#10417](https://github.com/Sylius/Sylius/issues/10417) [Admin] Order summary UI + discounts and taxes viewing logic ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10419](https://github.com/Sylius/Sylius/issues/10419) Add prices and discounts to the order summary box ([@kulczy](https://github.com/kulczy))
- [#10420](https://github.com/Sylius/Sylius/issues/10420) Change order summary table ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp))
- [#10429](https://github.com/Sylius/Sylius/issues/10429) Add admin user avatar placeholder ([@kulczy](https://github.com/kulczy))
- [#10438](https://github.com/Sylius/Sylius/issues/10438) Keep all prices in the same currency in checkout ([@pamil](https://github.com/pamil))
- [#10441](https://github.com/Sylius/Sylius/issues/10441) [Inventory][Product] Move inventory to new tab ([@AdamKasp](https://github.com/AdamKasp))
- [#10442](https://github.com/Sylius/Sylius/issues/10442) Add an alert about unsaved changes ([@kulczy](https://github.com/kulczy))
- [#10443](https://github.com/Sylius/Sylius/issues/10443) Unify shipping row on the order summary table ([@kulczy](https://github.com/kulczy))
- [#10444](https://github.com/Sylius/Sylius/issues/10444) Change dashboard view ([@kulczy](https://github.com/kulczy), [@pamil](https://github.com/pamil))
- [#10449](https://github.com/Sylius/Sylius/issues/10449) Administrator's avatar ([@Tomanhez](https://github.com/Tomanhez), [@Zales0123](https://github.com/Zales0123))
- [#10451](https://github.com/Sylius/Sylius/issues/10451) [Admin] Add possibility to configure custom index route in routing ([@GSadee](https://github.com/GSadee))
- [#10453](https://github.com/Sylius/Sylius/issues/10453) Fix deprecation notice ([@loevgaard](https://github.com/loevgaard))
- [#10455](https://github.com/Sylius/Sylius/issues/10455) Improve admin product show page UI ([@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#10460](https://github.com/Sylius/Sylius/issues/10460) AvatarImage Doctrine mapping fix ([@bartoszpietrzak1994](https://github.com/bartoszpietrzak1994))
- [#10461](https://github.com/Sylius/Sylius/issues/10461) Fix product show page elements ([@kulczy](https://github.com/kulczy))
